<?php

/**
 * Child Theme Function
 *
 */

add_action( 'after_setup_theme', 'camille_child_theme_setup' );
add_action( 'wp_enqueue_scripts', 'camille_child_enqueue_styles', 20);

if( !function_exists('camille_child_enqueue_styles') ) {
    function camille_child_enqueue_styles() {
        wp_enqueue_style( 'camille-child-style',
            get_stylesheet_directory_uri() . '/style.css',
            array( 'camille-theme' ),
            wp_get_theme()->get('Version')
        );
    }
}

if( !function_exists('camille_child_theme_setup') ) {
    function camille_child_theme_setup() {
        load_child_theme_textdomain( 'camille-child', get_stylesheet_directory() . '/languages' );
    }
}